////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/CryptoAppIndex.h>
#import <MSSOrchestration/ProtectionType.h>
#import <MSSOrchestration/OrchestrationUser.h>
NS_ASSUME_NONNULL_BEGIN

@protocol LocalAuthenticationDelegate;

/**
 * Parameters for performing a local authentication.
 */
NS_REFINED_FOR_SWIFT
@interface LocalAuthenticationParams : NSObject

/**
 * Gets the configured user for performing a local authentication.
 * @return the configured user
 */
@property (nonatomic, strong) OrchestrationUser *orchestrationUser;

/**
 * @return the crypto app index used to generate the one-time password.
 */
@property (nonatomic) CryptoAppIndex cryptoAppIndex;

/**
 * @return the challenge used when computing the one-time password.
 */
@property (nonatomic, strong, nullable) NSString* challenge;

/**
 * @return the protection type used to generate the one-time password.
 */
@property (nonatomic) ProtectionType protectionType;

/**
 * @return the callback used to receive events related to local authentication.
 */
@property (nonatomic, weak) id<LocalAuthenticationDelegate> localAuthenticationDelegate;

@end

NS_ASSUME_NONNULL_END
